#ifndef __KF_IVECT_H
#define __KF_IVECT_H

#include "kf_vect.h"

/** Die Klasse KF_IVector speichert einen Vector von Pointern.
  * Der groesste benutzte Indize wird gemerkt.
  * Ist ein Element nicht vorhanden, so wird NULL zurueckgeben.
*/

template <class TYPE>
class KF_IVector : public KF_Vector<TYPE *>
{
	public:
		KF_IVector(int p_ownselements = 0)
			: KF_Vector<TYPE *>(NULL)
		{
			ownselements = p_ownselements;
			//ASSERT(minimum == myindexlist->GetHead()
			//	|| (minimum==0 && maximum==-1));
			//ASSERT(maximum == myindexlist->GetTail()
			//	|| (minimum==0 && maximum==-1));
		}
		
		KF_IVector(int p_ownselements,TYPE ** newdata,int newsize,
			int newindexoffset, int newminimum,int newmaximum,
			int newcount)
			: KF_Vector<TYPE *>(NULL,newdata,newsize,newindexoffset,newminimum,newmaximum,
			newcount)
		{
			ownselements = p_ownselements;
		}
		
		virtual ~KF_IVector(void);

		virtual void Delete(int index)
		{
			//ASSERT(minimum == myindexlist->GetHead()
			//	|| (minimum==0 && maximum==-1));
			//ASSERT(maximum == myindexlist->GetTail()
			//	|| (minimum==0 && maximum==-1));
// 			TYPE *p;
			if (ownselements)
			{
				if (data[index - indexoffset ] != NULL)
				{
					ASSERT( index >= minimum );
					ASSERT( index <= maximum );
					delete data[ index - indexoffset ];

					KF_Vector<TYPE *>::Delete(index);
					// this does the adjustment of minimum
					// and maximum (hopefully)

				}
				//p = Get(index);
				//if (p != NULL)
				//{
				//	delete p;
				//	KF_Vector<TYPE *>::Delete(index);
				//}
			}
			else
				KF_Vector<TYPE *>::Delete(index);
		}
		
		virtual void Cut(int index,KF_IVector<TYPE> **ppvect);
		virtual void CutBegin(int index,KF_IVector<TYPE> **ppvect);

		virtual void setOwnership(int p_ownselements)
		{ 
			ownselements = p_ownselements; 
		}
		virtual int getOwnership(void) const
		{ return ownselements; }

	protected:
		int ownselements; // 1: Datenelemente des Vektors werden geloescht
};

template <class TYPE>
KF_IVector<TYPE>::~KF_IVector(void)
{
//	ASSERT(minimum == myindexlist->GetHead()
//		|| (minimum==0 && maximum==-1));
//	ASSERT(maximum == myindexlist->GetTail()
//		|| (minimum==0 && maximum==-1));
//	TYPE *p;
	if (ownselements)
	{
		int i;
		for (i=0;i<memsize;i++)
		{
			if (data[i] != NULL)
			{
				ASSERT( i+indexoffset >= minimum);
				ASSERT( i+indexoffset <= maximum);
				delete data[i];
			}
		}
//		for (int i=GetMinimum();i<=GetMaximum();i++)
//		{
//			if ( (p = Get(i)) != NULL)
//				delete p;
//		}
	}
	// der StandardDestuktor von KF_Vector sorgt dafuer, dass
	// die Vektorstrukturen ebenfalls geloescht werden
}

// this operation cuts a vector in two
// the old vector reaches from
// minimum to index, the new vector
// (which is constructed within the function)
// ranges from index+1 till maximum.
template <class TYPE>
void KF_IVector<TYPE>::Cut(int index,KF_IVector<TYPE> **pnew)
{
//	ASSERT(minimum == myindexlist->GetHead()
//		|| (minimum==0 && maximum==-1));
//	ASSERT(maximum == myindexlist->GetTail()
//		|| (minimum==0 && maximum==-1));



	*pnew = NULL;
	if (index< minimum)
		return;
	if (index>maximum)
		return;


	int mymemindex = index - indexoffset;


	int newmin = INT_MAX;
	int newmax = INT_MIN;

	int newsize = maximum - index;
	if (newsize > 0)
	{
		// we make sure, that there are -10 left and +10 on the
		// right hand side ....
	   int newindexoffset = 10;

	   TYPE **newdata = (TYPE **) malloc((newsize + 2*newindexoffset ) * sizeof( TYPE *) );

	   int i;
	   int newcount = 0;
	   for (i=0;i<newindexoffset;i++)
	   {
		   newdata[i] = noelement;
	   }
	   for (i=newindexoffset;i<newsize+newindexoffset;i++)
	   {
		   newdata[i] = (TYPE *) data[mymemindex + 1 + i - newindexoffset] ;
		   if (newdata[i] != noelement)
		   {
			   int tmpindex = mymemindex + indexoffset + i - newindexoffset;
			   if (tmpindex < newmin)
				   newmin = tmpindex;
			   if (tmpindex > newmax)
				   newmax = tmpindex;

			   newcount++;
			   data[mymemindex + 1 + i - newindexoffset] = noelement;
		   }
	   }
	   for (i=newsize+newindexoffset;i<newsize+2*newindexoffset;i++)
	   {
		   newdata[i] = noelement;
	   }

	   if (newmin > newmax)
	   {
		   newmin = 0;
		   newmax = -1;
		   ASSERT(newcount == 0);
	   }


		// create the new vector.
		*pnew  = new KF_IVector<TYPE>(ownselements,newdata,newsize+2*newindexoffset,
			newmin - newindexoffset,newmin, newmax, newcount); // index+1,maximum,newcount);


		// we have to change the maximum and minimum and also the elements ....
		count = count - newcount;
		if (count == 0)
		{
			minimum = 0;
			maximum = -1;
		}
		else
		{
			int newmaximum = index;
			while (newmaximum >= minimum &&
				data[newmaximum - indexoffset] == noelement)
				newmaximum--;
			maximum = newmaximum;
		}

	}
	else
	{
		// the new vector has no size ....
		*pnew = new KF_IVector<TYPE>(ownselements);
	}


	// create the new vector.
//	*pnew  = new KF_IVector<TYPE>(ownselements);
	

	// first find the location of the cut.

	
//	POSITION posi = myindexlist->GetHeadPosition();
//	POSITION posd = mydatalist->GetHeadPosition();
//	while (posi)
//	{
		
//		if (myindexlist->GetAt(posi) == index)
//		{
//			POSITION newposi = posi;
//			myindexlist->GetNext(newposi);
//			POSITION newposd = posd;
//			mydatalist->GetNext(newposd);

//			if (newposi)
//			{
//				ASSERT(newposd);
//				(*pnew)->myindexlist->SetHeadPosition(newposi);
//				(*pnew)->mydatalist->SetHeadPosition(newposd);

//				(*pnew)->minimum = (*pnew)->myindexlist->GetHead();
//				(*pnew)->maximum = (*pnew)->myindexlist->GetTail();
//			}

//			// then we have the break-position ...
//			myindexlist->SetTailPosition(posi);
//			mydatalist->SetTailPosition(posd);

//			minimum = myindexlist->GetHead();
//			maximum = myindexlist->GetTail();
//			break;
//		}
		
//		myindexlist->GetNext(posi);
//		mydatalist->GetNext(posd);
//	}

//	ASSERT(minimum == myindexlist->GetHead()
//		|| (minimum==0 && maximum==-1));
//	ASSERT(maximum == myindexlist->GetTail()
//		|| (minimum==0 && maximum==-1));

//	ASSERT((*pnew)->minimum == (*pnew)->myindexlist->GetHead()
//		|| ((*pnew)->minimum==0 && (*pnew)->maximum==-1));
//	ASSERT( (*pnew)->maximum == (*pnew)->myindexlist->GetTail()
//		|| ((*pnew)->minimum==0 && (*pnew)->maximum==-1));

}

// this operation cuts a vector in two
// the old vector reaches from
// index+1 to maximum and the new vector (pnew) goes
// from minimum to index.
template <class TYPE>
void KF_IVector<TYPE>::CutBegin(int index,KF_IVector<TYPE> **pnew)
{

	*pnew = NULL;
	if (index< minimum)
		return;
	if (index>maximum)
		return;

	int mymemindex = minimum - indexoffset;


	int newmin = INT_MAX;
	int newmax = INT_MIN;
	int newsize = index - minimum + 1;
	if (newsize > 0)
	{
		// we make sure, that there are -10 left and +10 on the
		// right hand side ....
	   int newindexoffset = 10;

	   TYPE **newdata = (TYPE **) malloc((newsize + 2*newindexoffset ) * sizeof( TYPE *) );

	   int i;
	   int newcount = 0;
	   for (i=0;i<newindexoffset;i++)
	   {
		   newdata[i] = noelement;
	   }
	   for (i=newindexoffset;i<newsize+newindexoffset;i++)
	   {
		   newdata[i] = (TYPE *) data[mymemindex + i - newindexoffset] ;
		   if (newdata[i] != noelement)
		   {
			   int tmpindex = mymemindex + indexoffset + i - newindexoffset;
			   if (tmpindex < newmin)
				   newmin = tmpindex;
			   if (tmpindex > newmax)
				   newmax = tmpindex;
			   newcount++;
			   data[mymemindex + i - newindexoffset] = noelement;
		   }
	   }
	   for (i=newsize+newindexoffset;i<newsize+2*newindexoffset;i++)
	   {
		   newdata[i] = noelement;
	   }

	   if (newmin > newmax)
	   {
		   newmin = 0;
		   newmax = -1;
		   ASSERT(newcount == 0);
	   }
		// create the new vector.
		*pnew  = new KF_IVector<TYPE>(ownselements,newdata,newsize+2*newindexoffset,
			newmin - newindexoffset,newmin,newmax,newcount); // minimum,index,newcount);


		// we have to change the maximum and minimum and also the elements ....
		// find the new minimum ....
		
		count = count - newcount;
		if (count == 0)
		{
			minimum = 0;
			maximum = -1;

		}
		else 
		{
			int newminimum = index + 1;
		    while (newminimum <= maximum &&
				data[newminimum - indexoffset] == noelement)
				newminimum++;
			minimum = newminimum; 
		}

	}
	else
	{
		// the new vector has no size ....
		*pnew = new KF_IVector<TYPE>(ownselements);
	}

}

#endif /* __KF_IVECT_H */